﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace ITA_580
{
    public partial class Form1
    {
        #region dllimport

        [DllImport("kernel32.dll")]
        public static extern IntPtr LoadLibrary(string dllToLoad);

        [DllImport("kernel32.dll")]
        public static extern bool FreeLibrary(IntPtr handle);

        #endregion  // dllimport

        #region init

        //=============================================================================
        //  Initialize
        //=============================================================================

        // 1st EC (primary EC)
        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.SysInt)]
        public extern static IntPtr AecInitialize(ref byte sts);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.I1)]
        public extern static byte AecUninitialize(IntPtr handle);

        #endregion  // init

        #region passthru

        //=============================================================================
        //  Pass Through Command
        //=============================================================================

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecPassThruCommand(IntPtr handl, byte typ, byte[] buf);

        #endregion  // passthru

        #region info

        //=============================================================================
        //  Information
        //=============================================================================

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecInfoGetBoardName(IntPtr handl, byte[] name);

        #endregion  // info

        #region wdt

        //=============================================================================
        //	WatchDog Timer
        //=============================================================================

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecWdtGetStatus(IntPtr handle, ref byte sts);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecWdtSendCommandStart(IntPtr handle);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecWdtSendCommandStop(IntPtr handle);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecWdtGetDelayTime(IntPtr handle, ref UInt32 time);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecWdtSetDelayTime(IntPtr handle, UInt32 time);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecWdtGetPowerBtnEventTime(IntPtr handle, ref UInt32 time);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecWdtSetPowerBtnEventTime(IntPtr handle, UInt32 time);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecWdtGetResetEventTime(IntPtr handle, ref UInt32 time);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecWdtSetResetEventTime(IntPtr handle, UInt32 time);

        #endregion  // wdt

        #region fan

        //=============================================================================
        //	Fan
        //=============================================================================

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecFanGetNum(IntPtr handle);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecFanGetMask(IntPtr handle, ref byte mask);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecFanGetRpm(IntPtr handle, byte ch, ref UInt16 rpm);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecFanGetTemperature(IntPtr handle, byte ch, ref Int16 temp);

        #endregion  // fan

        #region gpio

        //=============================================================================
        //	Peripheral : GPIO
        //=============================================================================

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecGpioGetNum(IntPtr handle);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecGpioGetChannelMask(IntPtr handle, ref UInt16 mask);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecGpioGetPinDir(IntPtr handle, byte ch, ref byte dir);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecGpioSetPinDir(IntPtr handle, byte ch, byte dir);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecGpioGetPinLevel(IntPtr handle, byte ch, ref byte level);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecGpioSetPinLevel(IntPtr handle, byte ch, byte level);

        #endregion  // gpio

        #region smb

        //=============================================================================
        //	Peripheral : SMBus
        //=============================================================================

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecSmbGetNum(IntPtr handle);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecSmbGetChannelMask(IntPtr handle, ref byte mask);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecSmbProbe(IntPtr handle, byte ch, byte sla);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecSmbWriteByte(IntPtr handle, byte ch, byte sla, byte cmd, ref byte dat);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecSmbReadByte(IntPtr handle, byte ch, byte sla, byte cmd, ref byte dat);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecSmbWriteWord(IntPtr handle, byte ch, byte sla, byte cmd, byte[] dat);

        [DllImport("AEC64.dll", CallingConvention = CallingConvention.Cdecl)]
        [return: MarshalAs(UnmanagedType.U1)]
        public extern static byte AecSmbReadWord(IntPtr handle, byte ch, byte sla, byte cmd, byte[] dat);

        #endregion  // smb

    }
}
